#ifndef _MATH_CPP
#define _MATH_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int SquareRoot (int iInput)
{
    return (iInput * iInput);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int LoByte (unsigned int iInput)
{
    return ( (unsigned char) ( (iInput) & 0xff) );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int HiByte (unsigned int iInput)
{
    return ( (unsigned char) ((unsigned short)(iInput) >> 8) );
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int LongLength(long lIn)
{
    int iSz    = 0;
	long lBuf = 0;

    if(lIn < 0)
    {
        lBuf = (0 - lIn);
        iSz++;
    }
    else lBuf = lIn;

	do
	{
		lBuf /= 10;
		iSz++;
	}
	while(lBuf != 0);

    return iSz;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int IntLength(int iIn)
{
    return LongLength( (long) iIn);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int ReverseLong(long lIn)
{
	long iRevInt = 0;
	long lBuf = lIn;

	do
	{
        iRevInt = (((int) (lBuf % 10)) + (iRevInt * 10));
		lBuf /= 10;
	}
	while(lBuf != 0);

    return iRevInt;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int ReverseInt(int iIn)
{
    return ReverseLong((long) iIn);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD VersionToLong(int iBit1, int iBit2, int iBit3, int iBit4)
{
    return (((iBit1 * 1000l + iBit2) * 10l + iBit3) * 10l + iBit4);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void LongToVersion(DWORD dwInVer, int *iBit1, int *iBit2, int *iBit3, int *iBit4)
{

    *iBit4 = (int) dwInVer % 10l;
    dwInVer /= 10l;
    *iBit3 = (int) dwInVer % 10l;
    dwInVer /= 10l;
    *iBit2 = (int) dwInVer % 10l;
    *iBit1 = (int) dwInVer / 1000l;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
